import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/application/booking_statistics/booking_statistic_provider.dart';
import 'package:admin_desktop/infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/infrastructure/services/tr_keys.dart';
import 'package:admin_desktop/presentation/components/buttons/custom_refresher.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/booking/widgets/custom_square.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/booking/widgets/select_time_widget.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/booking/widgets/generate_booking_statistic_check.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/booking/widgets/statistics_page.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:remixicon_updated/remixicon_updated.dart';

import '../../../../../infrastructure/services/time_service.dart';

class BookingStatisticsPage extends ConsumerStatefulWidget {
  const BookingStatisticsPage({super.key});

  @override
  ConsumerState<BookingStatisticsPage> createState() =>
      _BookingStatisticsPage();
}

class _BookingStatisticsPage extends ConsumerState<BookingStatisticsPage> {
  @override
  void initState() {
    WidgetsBinding.instance.addPostFrameCallback((s) {
      ref
          .read(bookingStatisticsProvider.notifier)
          .getBookingCountStatistics(context);
    });
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(bookingStatisticsProvider);
    final event = ref.read(bookingStatisticsProvider.notifier);
    return CustomScaffold(
      body: (colors) => ListView(
        padding: const EdgeInsets.symmetric(vertical: 20, horizontal: 16),
        shrinkWrap: true,
        children: [
          Center(
              child: Container(
                height: 80,
                decoration: BoxDecoration(
                  color: Style.white,
                  borderRadius: BorderRadius.circular(AppConstants.radius)
                ),
                child: Row(
                            children: [
                20.horizontalSpace,
                Text(
                  AppHelpers.getTranslation(TrKeys.countStatistics),
                  style: Style.interBold(),
                ),
                Spacer(),
                CustomRefresher(
                  onTap: () {
                    event.getBookingCountStatistics(context);
                  },
                  isLoading: state.isLoading,
                ),
                20.horizontalSpace,
                InkWell(
                  onTap: () {
                    AppHelpers.showAlertDialog(
                      context: context,
                      child: SizedBox(
                        width: MediaQuery.sizeOf(context).width / 3,
                        child: SelectTimeWidget(),
                      ),
                    );
                  },
                  child: ButtonEffectAnimation(
                    child: Container(
                      padding: const EdgeInsets.symmetric(
                          vertical: 10, horizontal: 16),
                      decoration: BoxDecoration(
                        color: Style.white,
                        borderRadius: BorderRadius.circular(10),
                      ),
                      child: Row(
                        children: [
                          const Icon(Remix.calendar_check_line),
                          16.horizontalSpace,
                          Text(
                            state.startDate == null
                                ? AppHelpers.getTranslation(TrKeys.startEnd)
                                : TimeService.dateFormatFilter(
                                    start: state.startDate, end: state.endDate),
                            style: Style.interRegular(size: 12),
                          )
                        ],
                      ),
                    ),
                  ),
                ),
                20.horizontalSpace,
                InvoiceDownload(
                  child: GenerateBookingStatisticCheck(
                    statistic: state.bookingCountStatistics,
                  ),
                )
                            ],
                          ),
              )),
          20.verticalSpace,
          Row(
            //  crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              CustomSquare(
                title: TrKeys.newKey,
                count: state.bookingCountStatistics?.newBooked?.count,
              ),
              CustomSquare(
                  title: TrKeys.booked,
                  count: state.bookingCountStatistics?.booked?.count),
              CustomSquare(
                title: TrKeys.progress,
                count: state.bookingCountStatistics?.progress?.count,
              ),
              CustomSquare(
                title: TrKeys.canceled,
                count: state.bookingCountStatistics?.canceled?.count,
              ),
              CustomSquare(
                title: TrKeys.ended,
                count: state.bookingCountStatistics?.ended?.count,
              ),
            ],
          ),
          30.verticalSpace,
          Row(
            children: [
              20.horizontalSpace,
              Text(
                AppHelpers.getTranslation(TrKeys.percentStatistics),
                style: Style.interBold(),
              ),
            ],
          ),
          20.verticalSpace,
          StatisticPage(
            statistic: state.bookingCountStatistics,
          ),
          20.verticalSpace,
          Row(
            children: [
              20.horizontalSpace,
              Text(
                AppHelpers.getTranslation(TrKeys.totalStatistic),
                style: Style.interBold(),
              ),
            ],
          ),
          30.verticalSpace,
          Row(
            //  crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              CustomSquare(
                title: TrKeys.newKey,
                number: state.bookingCountStatistics?.newBooked?.totalPrice,
              ),
              CustomSquare(
                  title: TrKeys.booked,
                  number: state.bookingCountStatistics?.booked?.totalPrice),
              CustomSquare(
                title: TrKeys.progress,
                number: state.bookingCountStatistics?.progress?.totalPrice,
              ),
              CustomSquare(
                title: TrKeys.canceled,
                number: state.bookingCountStatistics?.canceled?.totalPrice,
              ),
              CustomSquare(
                title: TrKeys.ended,
                number: state.bookingCountStatistics?.ended?.totalPrice,
              ),
            ],
          )
        ],
      ),
    );
  }
}
